/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.NoSuchObjectIdException;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.managed.UIObjectsFilter;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.ui.AbstractUIAction;
import com.ibm.hwmca.fw.ui.DisplayChildrenUIAction;
import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.PermittedTargets;
import com.ibm.hwmca.fw.ui.ProductSpecificSupport;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UILog;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsOffsets;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIPropertyChangeEvent;
import com.ibm.hwmca.fw.ui.UIPropertyChangeSupport;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkThread;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIObjectsWriter
extends UIObjectProperties
implements PropertyChangeListener,
UILog {
    private ManagedObjectManager mom;
    private ShortObjectIdManager shortIdManager;
    private UIObjectsOffsets recordOffsets;
    private HashMap statusToShortId;
    private HashMap shortIdToStatus;
    private HashMap attentionTaskShortIds;
    private PermittedTargets permittedTargets;
    private HashMap listeners;
    private Object listenersLock = new Object();
    private Object attnLock = new Object();
    private Object actionsLock = new Object();
    private Worker worker;
    private File objectsFile;
    private RandomAccessFile objectsWriter;
    private File unacceptableFile;
    private File rootFile;
    private String groupFilePrefix;
    private String taskGroupFilePrefix;
    private String moGroupFilePrefix;
    private ProductSpecificSupport productSpecificSupport;
    private UIPropertyChangeSupport propertyChangeSupport;
    private static UIObjectsWriter instance;
    private HashMap uiActions;
    private static String[] MANAGED_OBJECT_PROPERTIES;
    private static String[] MANAGED_OBJECT_GROUP_PROPERTIES;
    private static String[] TASK_PROPERTIES;
    private static String[] TASK_GROUP_PROPERTIES;
    private static final String TRACE_MASKT = "HUIOBJWT";
    private static final String TRACE_MASKF = "HUIOBJWF";
    private static final String TRACE_MASKD = "HUIOBJWD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Task;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Group;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ClassId;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Status;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObjectGroup;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HMC;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$UserDefinedManagedObjectGroup;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$UserDefinedTaskGroup;

    private UIObjectsWriter() {
    }

    public static UIObjectsWriter getUIObjectsWriter() {
        if (instance == null) {
            throw new IllegalStateException("Error, the UIObjectsWriter singleton is null.");
        }
        return instance;
    }

    private void init() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsWriter.init()");
        try {
            this.statusToShortId = new HashMap();
            this.shortIdToStatus = new HashMap();
            this.attentionTaskShortIds = new HashMap();
            this.uiActions = new HashMap();
            this.mom = ManagedObjectManager.getManagedObjectManager();
            this.shortIdManager = new ShortObjectIdManager();
            String pathName = BaseFileControl.getFilePath("uitmp");
            File path = new File(pathName);
            if (!path.exists()) {
                path.mkdir();
            } else {
                File[] tempFiles = path.listFiles();
                for (int i = 0; i < tempFiles.length; ++i) {
                    tempFiles[i].delete();
                }
            }
            this.groupFilePrefix = pathName + "group.";
            this.taskGroupFilePrefix = this.groupFilePrefix + "task.";
            this.moGroupFilePrefix = this.groupFilePrefix + "mo.";
            this.objectsFile = new File(pathName + "objects");
            this.objectsWriter = new RandomAccessFile(this.objectsFile, "rws");
            this.recordOffsets = new UIObjectsOffsets(this.objectsWriter);
            this.unacceptableFile = new File(pathName + "unacceptablemanagedobjects");
            this.rootFile = new File(pathName + "rootmanagedobjects");
            this.worker = new Worker(this);
            ClassId[] types = new ClassId[]{new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject), new ClassId(class$com$ibm$hwmca$fw$managed$Task == null ? (class$com$ibm$hwmca$fw$managed$Task = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.Task")) : class$com$ibm$hwmca$fw$managed$Task), new ClassId(class$com$ibm$hwmca$fw$managed$Group == null ? (class$com$ibm$hwmca$fw$managed$Group = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.Group")) : class$com$ibm$hwmca$fw$managed$Group)};
            this.productSpecificSupport = new ProductSpecificSupport();
            this.permittedTargets = new PermittedTargets(this.shortIdManager, this);
            instance = this;
            this.mom.addPropertyChangeListener((PropertyChangeListener)this, true, types);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            HException hexc = null;
            hexc = exc instanceof HException ? (HException)exc : new HException(exc);
            new FrameworkLog(UILog.logInfo, 1804, hexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsWriter.init()");
    }

    public synchronized UIPropertyChangeSupport getUIPropertyChangeSupport() {
        Trace.trace(TRACE_MASKF, "<> UIObjectsWriter.getUIPropertyChangeSupport()");
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new UIPropertyChangeSupport();
        }
        return this.propertyChangeSupport;
    }

    public Set getAllowedShortIds() {
        return UIObjectsFilter.getAllowedShortIds(this.shortIdManager);
    }

    public Map getStatusToShortId() {
        return this.statusToShortId;
    }

    public Map getShortIdToStatus() {
        return this.shortIdToStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getUIActions() {
        Object object = this.actionsLock;
        synchronized (object) {
            return (Map)this.uiActions.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getUIActions(String[] shortIds) {
        HashMap<String, Collection> result = new HashMap<String, Collection>();
        Object object = this.actionsLock;
        synchronized (object) {
            for (int i = 0; i < shortIds.length; ++i) {
                Collection actions = (Collection)this.uiActions.get(shortIds[i]);
                if (actions == null || actions.size() <= 0) continue;
                result.put(shortIds[i], actions);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttentionTaskShortId(ObjectId taskObjectId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsWriter.addAttentionTaskShortId(), taskObjectId is " + taskObjectId);
        Object object = this.attnLock;
        synchronized (object) {
            if (!this.attentionTaskShortIds.containsKey(taskObjectId)) {
                String shortId = this.shortIdManager.add(taskObjectId);
                Trace.trace(TRACE_MASKF, "   adding shortId is " + shortId);
                this.attentionTaskShortIds.put(taskObjectId, shortId);
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsWriter.addAttentionTaskShortId()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAttentionTaskShortIds() {
        Object object = this.attnLock;
        synchronized (object) {
            return (Map)this.attentionTaskShortIds.clone();
        }
    }

    public ShortObjectIdManager getShortObjectIdManager() {
        return this.shortIdManager;
    }

    PermittedTargets getPermittedTargets() {
        return this.permittedTargets;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener, boolean allObjects) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsWriter.addPropertyChangeListener()");
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new HashMap();
            }
            ListenerData listenerData = null;
            if (!allObjects) {
                UserContext userContext = UserContext.getCurrentUserContext();
                listenerData = new ListenerData(listener, userContext);
            } else {
                listenerData = new ListenerData(listener, null);
            }
            this.listeners.put(listener, listenerData);
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsWriter.addPropertyChangeListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKT, "-> UIObjectsWriter.propertyChange()");
        this.worker.requestWork(evt);
        Trace.trace(TRACE_MASKT, "<- UIObjectsWriter.propertyChange()");
    }

    String getShortIdForTarget(ObjectId objectId) {
        String targetId = null;
        targetId = objectId.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject) ? (String)this.mom.getProperty(objectId, "TargetId") : objectId.getFullClassName();
        return this.getShortIdForTarget(objectId, targetId);
    }

    String getShortIdForTarget(ObjectId objectId, String targetId) {
        ObjectId classObjectId = new ObjectId((Object)(class$com$ibm$hwmca$fw$managed$ClassId == null ? (class$com$ibm$hwmca$fw$managed$ClassId = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ClassId")) : class$com$ibm$hwmca$fw$managed$ClassId));
        classObjectId.setKeyProperty("ClassTypeShortId", targetId);
        String classShortId = this.shortIdManager.add(classObjectId);
        return classShortId;
    }

    boolean updateSupportedStatus(Status[] supportedStatus) {
        boolean changed = false;
        if (supportedStatus != null) {
            for (int i = 0; i < supportedStatus.length; ++i) {
                if (this.statusToShortId.containsKey(supportedStatus[i])) continue;
                ObjectId statusObjectId = new ObjectId((Object)(class$com$ibm$hwmca$fw$managed$Status == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.Status") : class$com$ibm$hwmca$fw$managed$Status));
                String name = supportedStatus[i].getClass().getName() + ":" + supportedStatus[i].toString() + ":" + supportedStatus[i].hashCode();
                statusObjectId.setKeyProperty("Name", name);
                String statusShortId = this.shortIdManager.add(statusObjectId);
                this.statusToShortId.put(supportedStatus[i], statusShortId);
                this.shortIdToStatus.put(statusShortId, supportedStatus[i]);
                Trace.trace(TRACE_MASKF, "   new Status found, status shortId " + statusShortId + " is mapped to status " + supportedStatus[i] + " and class " + supportedStatus[i].getClass().getName());
                Trace.trace(TRACE_MASKF, "   key used in ObjectId is " + name);
                Trace.trace(TRACE_MASKF, "   hashCode is " + supportedStatus[i].hashCode());
                if (this.statusToShortId.size() != this.shortIdToStatus.size()) {
                    FrameworkLog log = new FrameworkLog(UILog.logInfo, 1820);
                    log.add("The size of the two status maps are no longer equal.  This can happen if two Status objects have the same hashcode.");
                    log.add(this.getStatusMapsAsString());
                    log.log();
                    continue;
                }
                changed = true;
            }
            Trace.trace(TRACE_MASKF, "   statusToShortId.size() is " + this.statusToShortId.size());
            Trace.trace(TRACE_MASKF, "   shortIdToStatus.size() is " + this.shortIdToStatus.size());
        }
        return changed;
    }

    String getStatusMapsAsString() {
        String nextShortId;
        Status nextStatus;
        StringBuffer buffer = new StringBuffer("Dumping status to shortId map, size is " + this.shortIdToStatus.size());
        Iterator iterator = this.statusToShortId.keySet().iterator();
        while (iterator.hasNext()) {
            nextStatus = (Status)iterator.next();
            nextShortId = (String)this.statusToShortId.get(nextStatus);
            buffer.append("\n  statusShortId is " + nextShortId + ", status is " + nextStatus + ", class is " + nextStatus.getClass().getName());
            buffer.append(", status hashCode is " + nextStatus.hashCode());
            buffer.append(", ObjectId is " + this.shortIdManager.getObjectId(nextShortId));
        }
        buffer.append("\n\nDumping shortId to status map, sizeof " + this.shortIdToStatus.size());
        iterator = this.shortIdToStatus.keySet().iterator();
        while (iterator.hasNext()) {
            nextShortId = (String)iterator.next();
            nextStatus = (Status)this.shortIdToStatus.get(nextShortId);
            buffer.append("\n  statusShortId is " + nextShortId + ", status is " + nextStatus + ", class is " + nextStatus.getClass().getName());
            buffer.append(", status hashCode is " + nextStatus.hashCode());
            buffer.append(", ObjectId is " + this.shortIdManager.getObjectId(nextShortId));
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MANAGED_OBJECT_PROPERTIES = new String[]{"AttentionTaskObjectId", "AttentionsExist", "Busy", "Locked", "ObjectId", "Root", "Status", "StatusAcceptable", "SupportedStatus", "UIInfo", "OpenTaskObjectId", "Children"};
        MANAGED_OBJECT_GROUP_PROPERTIES = new String[]{"Children", "Root", "StatusAcceptable", "UIInfo", "AttentionsExist"};
        TASK_PROPERTIES = new String[]{"UIInfo", "MergedKey", "TargetRequired", "Disruptive"};
        TASK_GROUP_PROPERTIES = new String[]{"Children", "Root", "UIInfo"};
    }

    public static final class Init
    implements Runnable {
        public void run() {
            Trace.trace(UIObjectsWriter.TRACE_MASKT, "-> UIObjectsWriter#Init.run()");
            new UIObjectsWriter().init();
            Trace.trace(UIObjectsWriter.TRACE_MASKT, "<- UIObjectsWriter#Init.run()");
        }
    }

    class ListenerData {
        UserContext userContext;
        PropertyChangeListener listener;

        ListenerData(PropertyChangeListener listener, UserContext userContext) {
            this.listener = listener;
            this.userContext = userContext;
        }
    }

    private class Worker
    implements WorkPerformer,
    WorkListener {
        private WorkThread workThread;
        private UIObjectsWriter instance;
        private static final int ADD = 1;
        private static final int REMOVE = 2;
        private static final int CHANGE = 3;

        public Worker(UIObjectsWriter instance) {
            this.instance = instance;
            this.workThread = new WorkThread("UIObjectsWriter.Worker");
            this.workThread.startWorker();
        }

        public void requestWork(PropertyChangeEvent evt) {
            this.workThread.requestWork(this, this, "ProperyChangeEvent", evt);
        }

        public Object performWork(Object data) {
            Trace.trace(UIObjectsWriter.TRACE_MASKT, "-> UIObjectsWriter.Worker.performWork()");
            PropertyChangeEvent evt = (PropertyChangeEvent)data;
            ObjectId source = (ObjectId)evt.getSource();
            String propertyName = evt.getPropertyName();
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "   source is " + source);
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "   propertyName is " + propertyName);
            try {
                if (source.equals(UIObjectsWriter.this.mom.getObjectId())) {
                    boolean eventType = false;
                    List changes = null;
                    ObjectId[] ids = (ObjectId[])evt.getOldValue();
                    if (ids == null) {
                        ids = (ObjectId[])evt.getNewValue();
                        changes = this.objectsAdded(ids);
                    } else {
                        changes = this.objectsRemoved(ids);
                    }
                } else {
                    String shortId = UIObjectsWriter.this.shortIdManager.getShortId(source);
                    if (shortId == null) {
                        String s = "Got a property change event from an unknown source.\n  source is " + source;
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, s);
                        HException hexc = new HException(s);
                        FrameworkLog log = new FrameworkLog(UILog.logInfo, 1805, hexc);
                        log.add(s);
                        log.add(evt);
                        log.log(MicrocodeLogAttributes.INFO_LOG);
                    } else if (UIObjectsWriter.this.recordOffsets.isOffsetKnown(shortId)) {
                        boolean isManagedObjectGroup = source.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? (class$com$ibm$hwmca$fw$managed$ManagedObjectGroup = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup")) : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup) || source.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject);
                        this.objectChanged(shortId, evt, isManagedObjectGroup);
                    } else {
                        String s = "The shortId is not in the objects file.\n  shortId is [" + shortId + "]\n  source is [" + source + "]";
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, s);
                        HException hexc = new HException(s);
                        FrameworkLog log = new FrameworkLog(UILog.logInfo, 1815, hexc);
                        log.add(s);
                        log.add(evt);
                        log.log(MicrocodeLogAttributes.INFO_LOG);
                    }
                }
            }
            catch (IOException ioexc) {
                Trace.trace(UIObjectsWriter.TRACE_MASKT, ioexc);
                new FrameworkLog(UILog.logInfo, 1806, ioexc).log();
                HException hexc = new HException(ioexc);
                FrameworkLog log = new FrameworkLog(UILog.logInfo, 1806, hexc);
                log.add(evt);
                log.log();
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKT, "<- UIObjectsWriter.Worker.performWork()");
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void objectChanged(String shortId, PropertyChangeEvent evt, boolean isManagedObjectGroup) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.objectChanged()");
            int offset = UIObjectsWriter.this.recordOffsets.getOffset(shortId);
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            String propertyName = evt.getPropertyName();
            ArrayList<UIPropertyChangeEvent> eventsToSend = new ArrayList<UIPropertyChangeEvent>();
            UIPropertyChangeEvent uiEvent = null;
            if (propertyName.equals("Status")) {
                Status[] newStatus;
                Status status = (Status)newValue;
                boolean createStatusMapEvent = UIObjectsWriter.this.productSpecificSupport.statusChanged(status, this.instance);
                if (!UIObjectsWriter.this.statusToShortId.containsKey(status) && UIObjectsWriter.this.updateSupportedStatus(newStatus = new Status[]{status})) {
                    createStatusMapEvent = true;
                }
                if (createStatusMapEvent) {
                    eventsToSend.add(new UIPropertyChangeEvent("UIObjectsWriter", "StatusToShortId", null, UIObjectsWriter.this.statusToShortId));
                    eventsToSend.add(new UIPropertyChangeEvent("UIObjectsWriter", "ShortIdToStatus", null, UIObjectsWriter.this.shortIdToStatus));
                }
                this.localizableTextChanged(status.getUIInfo().getUnlocalizedName(), offset, 280, 80, 360, 80);
                String statusShortId = this.getStatusShortId(status);
                byte[] buffer = new byte[8];
                this.copyString(buffer, statusShortId, 0, 8);
                UIObjectsWriter.this.objectsWriter.seek(offset + 16);
                UIObjectsWriter.this.objectsWriter.write(buffer);
                eventsToSend.add(new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue));
            } else if (propertyName.equals("Locked")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 13);
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean((Boolean)newValue, (byte)70));
                uiEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
                eventsToSend.add(uiEvent);
            } else if (propertyName.equals("Busy")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 10);
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean((Boolean)newValue, (byte)70));
                uiEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
                eventsToSend.add(uiEvent);
            } else if (propertyName.equals("StatusAcceptable")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 12);
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean((Boolean)newValue, (byte)70));
                Object[] ids = new String[]{shortId};
                if (((Boolean)newValue).booleanValue()) {
                    this.removeFromFile(ids, UIObjectsWriter.this.unacceptableFile);
                } else {
                    this.addToFile((String[])ids, UIObjectsWriter.this.unacceptableFile);
                }
                uiEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
                eventsToSend.add(uiEvent);
            } else if (propertyName.equals("AttentionsExist")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 14);
                Boolean b = (Boolean)newValue;
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean(b, (byte)70));
                eventsToSend.add(new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue));
                uiEvent = this.updateAttentionTask(shortId, b, isManagedObjectGroup);
                if (uiEvent != null) {
                    eventsToSend.add(uiEvent);
                }
            } else if (propertyName.equals("AttentionTaskObjectId")) {
                ObjectId attnTaskObjectId = (ObjectId)newValue;
                Trace.trace(UIObjectsWriter.TRACE_MASKF, "   new ATTENTION_TASK_OBJECTID_PROPERTY is " + attnTaskObjectId);
                UIObjectsWriter.this.addAttentionTaskShortId(attnTaskObjectId);
                String attnTaskShortId = UIObjectsWriter.this.shortIdManager.getShortId(attnTaskObjectId);
                byte[] buffer = new byte[8];
                this.copyString(buffer, attnTaskShortId, 0, 8);
                UIObjectsWriter.this.objectsWriter.seek(offset + 24);
                UIObjectsWriter.this.objectsWriter.write(buffer);
                uiEvent = new UIPropertyChangeEvent(shortId, propertyName, UIObjectsWriter.this.shortIdManager.getShortId((ObjectId)evt.getOldValue()), UIObjectsWriter.this.shortIdManager.getShortId((ObjectId)evt.getNewValue()));
                eventsToSend.add(uiEvent);
            } else if (propertyName.equals("Locked")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 13);
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean((Boolean)newValue, (byte)70));
                uiEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
                eventsToSend.add(uiEvent);
            } else if (propertyName.equals("Children")) {
                ObjectId source = (ObjectId)evt.getSource();
                String parentShortId = UIObjectsWriter.this.shortIdManager.getShortId(source);
                if (parentShortId != null) {
                    byte type = 52;
                    if (isManagedObjectGroup) {
                        type = 50;
                    }
                    if (newValue == null) {
                        this.removeFromGroupFile(parentShortId, type, (ObjectId[])evt.getOldValue());
                    } else {
                        this.addToGroupFile(parentShortId, type, (ObjectId[])newValue);
                    }
                }
                uiEvent = new UIPropertyChangeEvent(shortId, propertyName, this.getShortIds((ObjectId[])evt.getOldValue()), this.getShortIds((ObjectId[])evt.getNewValue()));
                eventsToSend.add(uiEvent);
            } else if (propertyName.equals("UIInfo")) {
                Iterator iterator;
                UIInfo newUIInfo = (UIInfo)newValue;
                this.localizableTextChanged(newUIInfo.getUnlocalizedName(), offset, 120, 80, 200, 80);
                this.localizableTextChanged(newUIInfo.getUnlocalizedCaption(), offset, 600, 80, 680, 80);
                this.imageNameChanged(newUIInfo.getImageName(), offset, 40, 80);
                uiEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
                eventsToSend.add(uiEvent);
                Collection actions = newUIInfo.getUIActions();
                if (actions != null && actions.size() > 0) {
                    iterator = actions.iterator();
                    while (iterator.hasNext()) {
                        AbstractUIAction next = (AbstractUIAction)iterator.next();
                        if (!(next instanceof DisplayChildrenUIAction)) continue;
                        DisplayChildrenUIAction action = (DisplayChildrenUIAction)next;
                        String groupShortId = UIObjectsWriter.this.shortIdManager.add(action.getGroupObjectId());
                        action.setGroupShortId(groupShortId);
                    }
                }
                iterator = UIObjectsWriter.this.actionsLock;
                synchronized (iterator) {
                    if (actions != null && actions.size() > 0) {
                        UIObjectsWriter.this.uiActions.put(shortId, actions);
                    } else {
                        UIObjectsWriter.this.uiActions.remove(shortId);
                    }
                }
            } else if (propertyName.equals("Root")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 11);
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean((Boolean)newValue, (byte)70));
                Object[] ids = new String[]{shortId};
                if (((Boolean)newValue).booleanValue()) {
                    this.addToFile((String[])ids, UIObjectsWriter.this.rootFile);
                } else {
                    this.removeFromFile(ids, UIObjectsWriter.this.rootFile);
                }
                uiEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
                eventsToSend.add(uiEvent);
            } else if (propertyName.equals("SupportedStatus")) {
                if (UIObjectsWriter.this.updateSupportedStatus((Status[])evt.getNewValue())) {
                    eventsToSend.add(new UIPropertyChangeEvent("UIObjectsWriter", "StatusToShortId", null, UIObjectsWriter.this.statusToShortId));
                    eventsToSend.add(new UIPropertyChangeEvent("UIObjectsWriter", "ShortIdToStatus", null, UIObjectsWriter.this.shortIdToStatus));
                }
            } else if (propertyName.equals("OpenTaskObjectId")) {
                ObjectId openTaskObjectId = (ObjectId)newValue;
                Trace.trace(UIObjectsWriter.TRACE_MASKF, "   new OPEN_TASK_OBJECTID_PROPERTY is " + openTaskObjectId);
                String openTaskShortId = UIObjectsWriter.this.shortIdManager.add(openTaskObjectId);
                Trace.trace(UIObjectsWriter.TRACE_MASKF, "   openTaskShortId is " + openTaskShortId);
                byte[] buffer = new byte[8];
                this.copyString(buffer, openTaskShortId, 0, 8);
                UIObjectsWriter.this.objectsWriter.seek(offset + 760);
                UIObjectsWriter.this.objectsWriter.write(buffer);
                uiEvent = new UIPropertyChangeEvent(shortId, propertyName, UIObjectsWriter.this.shortIdManager.getShortId((ObjectId)evt.getOldValue()), openTaskShortId);
                eventsToSend.add(uiEvent);
            } else {
                Trace.trace(UIObjectsWriter.TRACE_MASKF, "Error in UIObjectsWriter.Worker.objectChanged(), unknown property received, property name is " + propertyName);
            }
            if (eventsToSend.size() > 0) {
                this.sendChangeEvent((ObjectId)evt.getSource(), eventsToSend);
                if (uiEvent != null && UIObjectsWriter.this.propertyChangeSupport != null) {
                    if (propertyName.equals("Root")) {
                        UIObjectsWriter.this.propertyChangeSupport.notifyRootPropertyChangeListener(uiEvent);
                    } else {
                        UIObjectsWriter.this.propertyChangeSupport.notifyPropertyChangeListener(uiEvent);
                    }
                }
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.objectChanged()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List objectsAdded(ObjectId[] ids) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.objectsAdded()");
            Object newAttnTaskShortIds = null;
            ArrayList<String> addedShortIds = new ArrayList<String>();
            ArrayList<String> unacceptableShortIds = null;
            ArrayList<String> rootShortIds = null;
            String[] propertyNames = null;
            byte[] buffer = new byte[770];
            byte type = 48;
            ArrayList<UIPropertyChangeEvent> eventsToSend = null;
            for (int i = 0; i < ids.length; ++i) {
                try {
                    Boolean b;
                    List children;
                    boolean isRoot = false;
                    if (ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$HMC == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.HMC") : class$com$ibm$hwmca$fw$managed$HMC)) {
                        type = 55;
                        propertyNames = MANAGED_OBJECT_PROPERTIES;
                    } else if (ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObject") : class$com$ibm$hwmca$fw$managed$ManagedObject)) {
                        type = 49;
                        propertyNames = MANAGED_OBJECT_PROPERTIES;
                    } else if (ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup") : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup)) {
                        type = ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$UserDefinedManagedObjectGroup == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.UserDefinedManagedObjectGroup") : class$com$ibm$hwmca$fw$managed$UserDefinedManagedObjectGroup) ? (byte)56 : 50;
                        propertyNames = MANAGED_OBJECT_GROUP_PROPERTIES;
                    } else if (ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$Group == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.Group") : class$com$ibm$hwmca$fw$managed$Group)) {
                        type = ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$UserDefinedTaskGroup == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.UserDefinedTaskGroup") : class$com$ibm$hwmca$fw$managed$UserDefinedTaskGroup) ? (byte)54 : (ids[i].getKeyProperty("Name").equals("base.taskgroup.consact") ? (byte)53 : 52);
                        propertyNames = TASK_GROUP_PROPERTIES;
                    } else if (ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$Task == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.Task") : class$com$ibm$hwmca$fw$managed$Task)) {
                        type = 51;
                        propertyNames = TASK_PROPERTIES;
                    } else {
                        propertyNames = null;
                    }
                    if (propertyNames == null) {
                        String s = "MOM sent an invalid object type.\nObjectId is " + ids[i];
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, s);
                        FrameworkLog log = new FrameworkLog(UILog.logInfo, 1805);
                        log.add(s);
                        log.log(MicrocodeLogAttributes.INFO_LOG);
                        continue;
                    }
                    for (int j = 0; j < propertyNames.length; ++j) {
                        UIObjectsWriter.this.mom.addPropertyChangeListener(ids[i], propertyNames[j], this.instance, false);
                    }
                    Map properties = UIObjectsWriter.this.mom.getProperties(ids[i], propertyNames);
                    String shortId = UIObjectsWriter.this.shortIdManager.add(ids[i]);
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "   add shortId " + shortId + " for ObjectId " + ids[i]);
                    int offset = -1;
                    if (UIObjectsWriter.this.recordOffsets.isOffsetKnown(shortId)) {
                        offset = UIObjectsWriter.this.recordOffsets.getOffset(shortId);
                    } else {
                        offset = (int)UIObjectsWriter.this.objectsWriter.length();
                        UIObjectsWriter.this.recordOffsets.add(shortId, offset);
                    }
                    if (UIObjectProperties.isGroup(type) && (children = (List)properties.get("Children")) != null) {
                        this.addToGroupFile(shortId, type, children);
                    }
                    boolean sendStatusMapEvent = this.initObjectsFileBuffer(shortId, ids[i], properties, type, buffer);
                    if (UIObjectProperties.isManagedObject(type)) {
                        Set supportedStatus = (Set)properties.get("SupportedStatus");
                        Status[] supportedStatusArray = supportedStatus.toArray(new Status[supportedStatus.size()]);
                        sendStatusMapEvent = UIObjectsWriter.this.updateSupportedStatus(supportedStatusArray);
                    }
                    if (sendStatusMapEvent) {
                        if (eventsToSend == null) {
                            eventsToSend = new ArrayList<UIPropertyChangeEvent>();
                        }
                        eventsToSend.add(new UIPropertyChangeEvent("UIObjectsWriter", "StatusToShortId", null, UIObjectsWriter.this.statusToShortId));
                        eventsToSend.add(new UIPropertyChangeEvent("UIObjectsWriter", "ShortIdToStatus", null, UIObjectsWriter.this.shortIdToStatus));
                    }
                    UIObjectsWriter.this.objectsWriter.seek(offset);
                    UIObjectsWriter.this.objectsWriter.write(buffer);
                    addedShortIds.add(shortId);
                    if (UIObjectProperties.isManagedObject(type) || UIObjectProperties.isGroup(type)) {
                        b = (Boolean)properties.get("Root");
                        if (b == null) {
                            Trace.trace(UIObjectsWriter.TRACE_MASKD, "   root property is null");
                        } else {
                            Trace.trace(UIObjectsWriter.TRACE_MASKD, "   root property is " + b);
                        }
                        isRoot = false;
                        if (b != null && b.booleanValue()) {
                            isRoot = b;
                            if (rootShortIds == null) {
                                rootShortIds = new ArrayList<String>();
                            }
                            rootShortIds.add(shortId);
                        }
                    }
                    if (UIObjectProperties.isManagedObject(type) || UIObjectProperties.isManagedObjectGroup(type)) {
                        Boolean b2;
                        UIInfo uiInfo = (UIInfo)properties.get("UIInfo");
                        if (uiInfo != null) {
                            Collection actions = uiInfo.getUIActions();
                            Object actionEvent = null;
                            if (actions != null && actions.size() > 0) {
                                Iterator iterator = actions.iterator();
                                while (iterator.hasNext()) {
                                    AbstractUIAction next = (AbstractUIAction)iterator.next();
                                    if (!(next instanceof DisplayChildrenUIAction)) continue;
                                    DisplayChildrenUIAction action = (DisplayChildrenUIAction)next;
                                    String groupShortId = UIObjectsWriter.this.shortIdManager.add(action.getGroupObjectId());
                                    action.setGroupShortId(groupShortId);
                                }
                                Object object = UIObjectsWriter.this.actionsLock;
                                synchronized (object) {
                                    int numUIActions = UIObjectsWriter.this.uiActions.size();
                                    UIObjectsWriter.this.uiActions.put(shortId, actions);
                                    if (numUIActions != UIObjectsWriter.this.uiActions.size()) {
                                        if (eventsToSend == null) {
                                            eventsToSend = new ArrayList();
                                        }
                                        eventsToSend.add(new UIPropertyChangeEvent("UIObjectsWriter", "UIActions", null, UIObjectsWriter.this.uiActions.clone()));
                                    }
                                }
                            }
                        }
                        if ((b2 = (Boolean)properties.get("AttentionsExist")) == null) {
                            Trace.trace(UIObjectsWriter.TRACE_MASKF, "   attentions exist property is null");
                        } else {
                            Trace.trace(UIObjectsWriter.TRACE_MASKF, "   attentions exist property is " + b2);
                        }
                        if (b2 != null && b2.booleanValue()) {
                            ObjectId id = (ObjectId)properties.get("AttentionTaskObjectId");
                            if (id == null) {
                                Trace.trace(UIObjectsWriter.TRACE_MASKD, "   could not find attention task ObjectId");
                            } else {
                                UIPropertyChangeEvent attnEvent = this.updateAttentionTask(shortId, true, UIObjectProperties.isManagedObjectGroup(type));
                                Trace.trace(UIObjectsWriter.TRACE_MASKF, "   attnEvent is " + attnEvent);
                                if (attnEvent != null) {
                                    if (eventsToSend == null) {
                                        eventsToSend = new ArrayList();
                                    }
                                    eventsToSend.add(attnEvent);
                                }
                            }
                        }
                    }
                    if (UIObjectProperties.isManagedObject(type)) {
                        b = (Boolean)properties.get("StatusAcceptable");
                        if (b == null) {
                            Trace.trace(UIObjectsWriter.TRACE_MASKD, "   status acceptable property is null");
                        } else {
                            Trace.trace(UIObjectsWriter.TRACE_MASKD, "   status acceptable property is " + b);
                        }
                        if (b != null && !b.booleanValue()) {
                            if (unacceptableShortIds == null) {
                                unacceptableShortIds = new ArrayList<String>();
                            }
                            unacceptableShortIds.add(shortId);
                        }
                    }
                    UIObjectsWriter.this.permittedTargets.add(ids[i]);
                    if (!isRoot || UIObjectsWriter.this.propertyChangeSupport == null) continue;
                    UIObjectsWriter.this.propertyChangeSupport.notifyRootPropertyChangeListener(new UIPropertyChangeEvent(shortId, "Root", Boolean.FALSE, Boolean.TRUE));
                    continue;
                }
                catch (NoSuchObjectIdException exc) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "   objectId no longer exists in MOM, is is " + ids[i]);
                    continue;
                }
                catch (Exception exc) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, exc);
                    exc.printStackTrace();
                    FrameworkLog log = new FrameworkLog(UILog.logInfo, 1813, exc);
                    log.add("Caught exception adding ObjectId " + ids[i]);
                    log.log();
                }
            }
            if (unacceptableShortIds != null) {
                this.addToFile(unacceptableShortIds, UIObjectsWriter.this.unacceptableFile);
            }
            if (rootShortIds != null) {
                this.addToFile(rootShortIds, UIObjectsWriter.this.rootFile);
            }
            if (eventsToSend != null) {
                this.sendChangeEvent(null, eventsToSend);
            }
            if (addedShortIds.size() > 0) {
                this.sendInventoryEvent(1, addedShortIds);
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.objectsAdded()");
            return addedShortIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List objectsRemoved(ObjectId[] ids) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.objectsRemoved()");
            Object[] shortIdArray = new String[1];
            ArrayList<String> removedShortIds = new ArrayList<String>();
            for (int i = 0; i < ids.length; ++i) {
                String shortId = UIObjectsWriter.this.shortIdManager.getShortId(ids[i]);
                if (shortId == null) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "   could not find the shortId for ObjectId " + ids[i]);
                    continue;
                }
                try {
                    UIPropertyChangeEvent attnEvent;
                    byte[] buffer = this.getBuffer(shortId);
                    byte type = UIObjectProperties.getType(buffer);
                    boolean root = UIObjectProperties.isRoot(buffer);
                    int offset = UIObjectsWriter.this.recordOffsets.getOffset(shortId);
                    UIObjectsWriter.this.objectsWriter.seek(offset + 8);
                    UIObjectsWriter.this.objectsWriter.writeByte(84);
                    removedShortIds.add(shortId);
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "   shortId " + shortId + " marked as deleted");
                    UIObjectsWriter.this.permittedTargets.remove(ids[i]);
                    if (UIObjectProperties.isGroup(type)) {
                        String fileName = UIObjectProperties.isTaskGroup(type) ? UIObjectsWriter.this.taskGroupFilePrefix + shortId : UIObjectsWriter.this.moGroupFilePrefix + shortId;
                        File file = new File(fileName);
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   deleting file " + fileName);
                        file.delete();
                    }
                    if (root) {
                        shortIdArray[0] = shortId;
                        this.removeFromFile(shortIdArray, UIObjectsWriter.this.rootFile);
                    }
                    if (!UIObjectProperties.isManagedObject(type) && !UIObjectProperties.isManagedObjectGroup(type)) continue;
                    if (UIObjectProperties.attentionsExist(buffer) && (attnEvent = this.updateAttentionTask(shortId, false, UIObjectProperties.isManagedObjectGroup(type))) != null) {
                        this.sendChangeEvent(ids[i], attnEvent);
                    }
                    Object object = UIObjectsWriter.this.actionsLock;
                    synchronized (object) {
                        UIObjectsWriter.this.uiActions.remove(shortId);
                        continue;
                    }
                }
                catch (InvalidIdException exc) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, exc.toString());
                }
            }
            if (removedShortIds.size() > 0) {
                this.sendInventoryEvent(2, removedShortIds);
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.objectsRemoved()");
            return removedShortIds;
        }

        private void imageNameChanged(String imageName, int offset, int offsetImg, int lengthImg) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.imageNameChanged()");
            byte[] buffer = new byte[770];
            this.copyString(buffer, imageName, 0, lengthImg);
            Trace.trace(UIObjectsWriter.TRACE_MASKD, "   write [" + new String(buffer, 0, lengthImg) + "] at offset " + (offset + offsetImg));
            UIObjectsWriter.this.objectsWriter.seek(offset + offsetImg);
            UIObjectsWriter.this.objectsWriter.write(buffer, 0, lengthImg);
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.imageNameChanged()");
        }

        private void localizableTextChanged(LocalizableText text, int offset, int offsetRes, int lengthRes, int offsetKey, int lengthKey) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.localizableTextChanged()");
            byte[] buffer = new byte[770];
            this.copyString(buffer, text.getResourceBundleName(), 0, lengthRes);
            Trace.trace(UIObjectsWriter.TRACE_MASKD, "   write [" + new String(buffer, 0, lengthRes) + "] at offset " + (offset + offsetRes));
            UIObjectsWriter.this.objectsWriter.seek(offset + offsetRes);
            UIObjectsWriter.this.objectsWriter.write(buffer, 0, lengthRes);
            this.copyString(buffer, text.getKey(), 0, lengthKey);
            Trace.trace(UIObjectsWriter.TRACE_MASKD, "   write [" + new String(buffer, 0, lengthKey) + "] at offset " + (offset + offsetKey));
            UIObjectsWriter.this.objectsWriter.seek(offset + offsetKey);
            UIObjectsWriter.this.objectsWriter.write(buffer, 0, lengthKey);
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.localizableTextChanged()");
        }

        private boolean initObjectsFileBuffer(String shortId, ObjectId objectId, Map properties, byte type, byte[] buffer) {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.initObjectsFileBuffer()");
            boolean result = false;
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = 32;
            }
            this.copyString(buffer, shortId, 0, 8);
            if (properties == null) {
                buffer[8] = 84;
            } else {
                buffer[9] = type;
                buffer[8] = 70;
                UIInfo uiInfo = (UIInfo)properties.get("UIInfo");
                if (uiInfo == null) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "   UIInfo is null for objectId " + objectId);
                    this.copyString(buffer, "NO NAME", 200, 80);
                    this.copyString(buffer, "com/ibm/hwmca/fw/images/default.gif", 40, 80);
                } else {
                    LocalizableText text = uiInfo.getUnlocalizedName();
                    this.copyString(buffer, text.getResourceBundleName(), 120, 80);
                    this.copyString(buffer, text.getKey(), 200, 80);
                    LocalizableText caption = uiInfo.getUnlocalizedCaption();
                    this.copyString(buffer, caption.getResourceBundleName(), 600, 80);
                    this.copyString(buffer, caption.getKey(), 680, 80);
                    this.copyString(buffer, uiInfo.getImageName(), 40, 80);
                }
                Trace.trace(UIObjectsWriter.TRACE_MASKF, "write classObjectId");
                String classShortId = UIObjectsWriter.this.getShortIdForTarget(objectId);
                this.copyString(buffer, classShortId, 32, 8);
                Status status = null;
                String key = null;
                if (UIObjectProperties.isManagedObjectGroup(type) || UIObjectProperties.isManagedObject(type)) {
                    buffer[12] = this.getByteFromBoolean((Boolean)properties.get("StatusAcceptable"), (byte)70);
                    buffer[11] = this.getByteFromBoolean((Boolean)properties.get("Root"), (byte)70);
                    buffer[14] = this.getByteFromBoolean((Boolean)properties.get("AttentionsExist"), (byte)70);
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "   AttentionsExist property is " + properties.get("AttentionsExist"));
                    status = (Status)properties.get("Status");
                    if (status == null) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   Status property is null");
                    } else {
                        String statusShortId;
                        Status[] newStatus;
                        result = UIObjectsWriter.this.productSpecificSupport.statusChanged(status, this.instance);
                        if (!UIObjectsWriter.this.statusToShortId.containsKey(status) && UIObjectsWriter.this.updateSupportedStatus(newStatus = new Status[]{status})) {
                            result = true;
                        }
                        if ((uiInfo = status.getUIInfo()) != null) {
                            LocalizableText text = uiInfo.getUnlocalizedName();
                            this.copyString(buffer, text.getResourceBundleName(), 280, 80);
                            this.copyString(buffer, text.getKey(), 360, 80);
                        }
                        if ((statusShortId = this.getStatusShortId(status)) == null) {
                            Trace.trace(UIObjectsWriter.TRACE_MASKF, "   Could not find shortId for Status " + status);
                        } else {
                            Trace.trace(UIObjectsWriter.TRACE_MASKF, "   status shortId is " + statusShortId);
                            this.copyString(buffer, statusShortId, 16, 8);
                        }
                    }
                }
                if (UIObjectProperties.isManagedObject(type)) {
                    buffer[10] = this.getByteFromBoolean((Boolean)properties.get("Busy"), (byte)70);
                    buffer[13] = this.getByteFromBoolean((Boolean)properties.get("Locked"), (byte)70);
                    ObjectId attnTaskObjectId = (ObjectId)properties.get("AttentionTaskObjectId");
                    if (attnTaskObjectId == null) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   ATTENTION_TASK_OBJECTID_PROPERTY is null");
                    } else {
                        UIObjectsWriter.this.addAttentionTaskShortId(attnTaskObjectId);
                        String attnTaskShortId = UIObjectsWriter.this.shortIdManager.getShortId(attnTaskObjectId);
                        if (attnTaskShortId == null) {
                            attnTaskShortId = UIObjectsWriter.this.shortIdManager.add(attnTaskObjectId);
                        }
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   attnTaskShortId is " + attnTaskShortId);
                        this.copyString(buffer, attnTaskShortId, 24, 8);
                    }
                    ObjectId openTaskObjectId = (ObjectId)properties.get("OpenTaskObjectId");
                    if (openTaskObjectId == null) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   OPEN_TASK_OBJECTID_PROPERTY is null");
                    } else {
                        String openTaskShortId = UIObjectsWriter.this.shortIdManager.add(openTaskObjectId);
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   openTaskShortId is " + openTaskShortId);
                        this.copyString(buffer, openTaskShortId, 760, 8);
                    }
                } else if (!UIObjectProperties.isManagedObjectGroup(type)) {
                    if (UIObjectProperties.isTaskGroup(type)) {
                        buffer[11] = this.getByteFromBoolean((Boolean)properties.get("Root"), (byte)70);
                        key = (String)objectId.getKeyProperty("Name");
                        if (key != null) {
                            this.copyString(buffer, key, 440, 80);
                        }
                    } else if (UIObjectProperties.isTask(type)) {
                        Set set;
                        buffer[15] = this.getByteFromBoolean((Boolean)properties.get("TargetRequired"), (byte)84);
                        key = (String)objectId.getKeyProperty("Name");
                        if (key != null) {
                            this.copyString(buffer, key, 440, 80);
                        }
                        if ((key = (String)properties.get("MergedKey")) != null) {
                            this.copyString(buffer, key, 520, 80);
                        }
                        if ((set = this.getTaskShortIdsWithAttentions()).contains(shortId)) {
                            buffer[14] = 84;
                            Trace.trace(UIObjectsWriter.TRACE_MASKF, "attention exist set to true");
                        }
                        buffer[768] = this.getByteFromBoolean((Boolean)properties.get("Disruptive"), (byte)70);
                    } else {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   Error, type is unknown, type is " + type);
                    }
                }
            }
            buffer[buffer.length - 1] = 10;
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.initObjectsFileBuffer()");
            return result;
        }

        private String getStatusShortId(Status status) {
            Trace.trace(UIObjectsWriter.TRACE_MASKD, "-> UIObjectsWriter.Worker.getStatusShortId()");
            String statusShortId = (String)UIObjectsWriter.this.statusToShortId.get(status);
            if (statusShortId == null) {
                FrameworkLog log = new FrameworkLog(UILog.logInfo, 1819);
                log.add("Error, could not find the shortId for status " + status + " and class " + status.getClass().getName());
                log.add(UIObjectsWriter.this.getStatusMapsAsString());
                log.log();
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKD, "<- UIObjectsWriter.Worker.getStatusShortId(), returning is " + statusShortId);
            return statusShortId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getListeners() {
            ArrayList listenersClone = null;
            Object object = UIObjectsWriter.this.listenersLock;
            synchronized (object) {
                if (UIObjectsWriter.this.listeners != null && UIObjectsWriter.this.listeners.size() > 0) {
                    listenersClone = new ArrayList();
                    Iterator iterator = UIObjectsWriter.this.listeners.values().iterator();
                    while (iterator.hasNext()) {
                        listenersClone.add(iterator.next());
                    }
                }
            }
            return listenersClone;
        }

        private void sendChangeEvent(ObjectId objectId, List events) {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.sendChangeEvent()");
            List listeners = this.getListeners();
            if (listeners != null) {
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    ListenerData listenerData = (ListenerData)iterator.next();
                    if (objectId != null && listenerData.userContext != null && !UIObjectsFilter.isObjectAllowed(objectId, listenerData.userContext)) continue;
                    Iterator iterator2 = events.iterator();
                    while (iterator2.hasNext()) {
                        listenerData.listener.propertyChange((UIPropertyChangeEvent)iterator2.next());
                    }
                }
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.sendChangeEvent()");
        }

        private void sendChangeEvent(ObjectId objectId, UIPropertyChangeEvent event) {
            ArrayList<UIPropertyChangeEvent> events = new ArrayList<UIPropertyChangeEvent>();
            events.add(event);
            this.sendChangeEvent(objectId, events);
        }

        private void sendInventoryEvent(int eventType, List changes) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.sendInventoryEvent()");
            List listeners = this.getListeners();
            if (listeners != null) {
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    UIPropertyChangeEvent event;
                    ListenerData listenerData = (ListenerData)iterator.next();
                    Set allowedShortIds = null;
                    if (listenerData.userContext == null) {
                        allowedShortIds = new HashSet();
                        allowedShortIds.addAll(changes);
                    } else {
                        allowedShortIds = UIObjectsFilter.getAllowedShortIds(changes, listenerData.userContext, UIObjectsWriter.this.shortIdManager);
                    }
                    if (allowedShortIds.size() <= 0) continue;
                    String[] shortIds = allowedShortIds.toArray(new String[allowedShortIds.size()]);
                    if (eventType == 1) {
                        event = new UIPropertyChangeEvent("UIObjectsWriter", "AllowedShortIds", null, shortIds);
                        listenerData.listener.propertyChange(event);
                        event = new UIPropertyChangeEvent("UIObjectsWriter", "InventoryProperty", null, shortIds);
                        listenerData.listener.propertyChange(event);
                        if (UIObjectsWriter.this.propertyChangeSupport == null) continue;
                        UIObjectsWriter.this.propertyChangeSupport.notifyInventoryListeners(event);
                        continue;
                    }
                    event = new UIPropertyChangeEvent("UIObjectsWriter", "InventoryProperty", shortIds, null);
                    listenerData.listener.propertyChange(event);
                    if (UIObjectsWriter.this.propertyChangeSupport == null) continue;
                    UIObjectsWriter.this.propertyChangeSupport.notifyInventoryListeners(event);
                }
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.sendInventoryEvent()");
        }

        private UIPropertyChangeEvent updateAttentionTask(String moShortId, boolean moAttnsExist, boolean isManagedObjectGroup) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.updateAttentionTask()");
            UIPropertyChangeEvent result = null;
            try {
                Set attnTaskShortIds = this.getTaskShortIdsWithAttentions();
                byte[] buffer = this.getBuffer(moShortId);
                String taskShortId = UIObjectProperties.getAttentionTaskShortId(buffer);
                if (taskShortId == null && isManagedObjectGroup && (taskShortId = this.getAttentionTaskShortIdForGroup(moShortId)) != null) {
                    byte[] taskShortIdBuffer = new byte[8];
                    this.copyString(taskShortIdBuffer, taskShortId, 0, 8);
                    int offset = UIObjectsWriter.this.recordOffsets.getOffset(moShortId);
                    UIObjectsWriter.this.objectsWriter.seek(offset + 24);
                    UIObjectsWriter.this.objectsWriter.write(taskShortIdBuffer);
                }
                if (taskShortId != null) {
                    int taskOffset;
                    buffer = this.getBuffer(taskShortId);
                    boolean taskAttnsExist = UIObjectProperties.attentionsExist(buffer);
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "task attn exist is " + taskAttnsExist + ", managed object attn exist is " + moAttnsExist);
                    if (taskAttnsExist && !moAttnsExist) {
                        if (!attnTaskShortIds.contains(taskShortId)) {
                            taskOffset = UIObjectsWriter.this.recordOffsets.getOffset(taskShortId);
                            UIObjectsWriter.this.objectsWriter.seek(taskOffset + 14);
                            UIObjectsWriter.this.objectsWriter.writeByte(70);
                            result = new UIPropertyChangeEvent(taskShortId, "AttentionsExist", Boolean.TRUE, Boolean.FALSE);
                            Trace.trace(UIObjectsWriter.TRACE_MASKF, "attention exist set to false for task shortId " + taskShortId);
                        }
                    } else if (!taskAttnsExist && moAttnsExist) {
                        taskOffset = UIObjectsWriter.this.recordOffsets.getOffset(taskShortId);
                        UIObjectsWriter.this.objectsWriter.seek(taskOffset + 14);
                        UIObjectsWriter.this.objectsWriter.writeByte(84);
                        result = new UIPropertyChangeEvent(taskShortId, "AttentionsExist", Boolean.FALSE, Boolean.TRUE);
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "attention exist set to true for task shortId " + taskShortId);
                    }
                }
            }
            catch (InvalidIdException exc) {
                Trace.trace(UIObjectsWriter.TRACE_MASKF, exc.toString());
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.updateAttentionTask()");
            return result;
        }

        private String getAttentionTaskShortIdForGroup(String groupShortId) {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.getAttentionTaskShortIdForGroup()");
            String result = null;
            try {
                UIObjectsReader reader = new UIObjectsReader();
                List leaves = reader.getLeavesForGroup(groupShortId);
                Iterator iterator = leaves.iterator();
                while (iterator.hasNext() && result == null) {
                    String childShortId = (String)iterator.next();
                    byte[] buffer = reader.getBuffer(childShortId);
                    result = UIObjectsReader.getAttentionTaskShortId(buffer);
                }
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.getAttentionTaskShortIdForGroup(), result is " + result);
            return result;
        }

        private Set getTaskShortIdsWithAttentions() {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.getTaskShortIdsWithAttentions()");
            HashSet<String> result = new HashSet<String>();
            try {
                int numRecords = (int)(UIObjectsWriter.this.objectsWriter.length() / 770L);
                byte[] buffer = new byte[770];
                for (int i = 0; i < numRecords; ++i) {
                    String taskShortId;
                    UIObjectsWriter.this.objectsWriter.seek(i * 770);
                    int numRead = UIObjectsWriter.this.objectsWriter.read(buffer, 0, 770);
                    if (numRead != 770) {
                        throw new InvalidIdException("Could not read at offset " + i * 770 + ", should have read " + 770 + " bytes but only " + numRead + " bytes read.");
                    }
                    if (UIObjectProperties.isDeleted(buffer) || !UIObjectProperties.isManagedObject(buffer) || !UIObjectProperties.attentionsExist(buffer) || (taskShortId = UIObjectProperties.getAttentionTaskShortId(buffer)) == null || result.contains(taskShortId)) continue;
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "   adding taskShortId " + taskShortId);
                    result.add(taskShortId);
                }
            }
            catch (IOException ioexc) {
                Trace.trace(UIObjectsWriter.TRACE_MASKF, ioexc);
                new FrameworkLog(UILog.logInfo, 1803, ioexc).log();
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.getTaskShortIdsWithAttentions(), number returned is " + result.size());
            return result;
        }

        private byte[] getBuffer(String shortId) throws IOException {
            byte[] buffer = new byte[770];
            int offset = UIObjectsWriter.this.recordOffsets.getOffset(shortId);
            UIObjectsWriter.this.objectsWriter.seek(offset + 0);
            int numRead = UIObjectsWriter.this.objectsWriter.read(buffer, 0, 770);
            if (numRead != 770) {
                throw new InvalidIdException("Could not read shortId " + shortId + ", should have read " + 770 + " bytes but only " + numRead + " bytes read.");
            }
            return buffer;
        }

        private byte getByteFromBoolean(Boolean b, byte defaultValue) {
            if (b == null) {
                return defaultValue;
            }
            if (b.booleanValue()) {
                return 84;
            }
            return 70;
        }

        private byte[] getByteArray(int length, byte initValue) {
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = initValue;
            }
            return bytes;
        }

        private void copyString(byte[] buffer, String s, int offset, int maxLength) {
            int length = 0;
            byte[] source = null;
            if (s != null && s.length() > 0) {
                if (s.length() <= maxLength) {
                    length = s.length();
                } else {
                    length = maxLength;
                    String s2 = "Need to increase 'objects' record length.  Wrote the first " + maxLength + " bytes of String [" + s + "]";
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, s2);
                    FrameworkLog log = new FrameworkLog(UILog.logInfo, 1807);
                    log.add(s2);
                    log.log(MicrocodeLogAttributes.INFO_LOG);
                }
                source = s.getBytes();
            }
            for (int i = 0; i < maxLength; ++i) {
                buffer[i + offset] = i < length ? source[i] : 32;
            }
        }

        private void addToGroupFile(String parentShortId, byte type, List children) throws IOException {
            this.addToGroupFile(parentShortId, type, children.toArray(new ObjectId[children.size()]));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addToGroupFile(String parentShortId, byte type, ObjectId[] children) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.addToGroupFile()");
            OutputStreamWriter writer = null;
            try {
                try {
                    StringBuffer childrenBuffer = new StringBuffer();
                    for (int i = 0; i < children.length; ++i) {
                        childrenBuffer.append(UIObjectsWriter.this.shortIdManager.add(children[i]) + ",");
                    }
                    String fileName = UIObjectProperties.isTaskGroup(type) ? UIObjectsWriter.this.taskGroupFilePrefix + parentShortId : UIObjectsWriter.this.moGroupFilePrefix + parentShortId;
                    writer = new FileWriter(new File(fileName), true);
                    writer.write(childrenBuffer.toString());
                }
                catch (IOException ioexc) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, ioexc);
                    throw ioexc;
                }
                Object var8_9 = null;
                {
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (writer == null) throw throwable;
                    writer.close();
                    throw throwable;
                }
                catch (IOException ioexc) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioexc) {}
            if (writer != null) {
                writer.close();
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.addToGroupFile()");
        }

        private void removeFromGroupFiles(String parentShortId, byte type, List children) throws IOException {
            this.removeFromGroupFile(parentShortId, type, children.toArray(new ObjectId[children.size()]));
        }

        private void removeFromGroupFile(String parentShortId, byte type, ObjectId[] children) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.removeFromGroupFile()");
            String fileName = UIObjectProperties.isTaskGroup(type) ? UIObjectsWriter.this.taskGroupFilePrefix + parentShortId : UIObjectsWriter.this.moGroupFilePrefix + parentShortId;
            this.removeFromFile(children, new File(fileName));
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.removeFromGroupFile()");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void removeFromFile(Object[] ids, File file) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.removeFromFile()");
            InputStreamReader reader = null;
            OutputStreamWriter writer = null;
            try {
                block13: {
                    try {
                        if (!file.exists() || file.length() <= 0L) break block13;
                        reader = new FileReader(file);
                        char[] buffer = new char[(int)file.length()];
                        int numRead = reader.read(buffer);
                        reader.close();
                        reader = null;
                        if ((long)numRead != file.length()) break block13;
                        StringBuffer sb = new StringBuffer();
                        sb.append(buffer);
                        for (int i = 0; i < ids.length; ++i) {
                            int index;
                            String next = null;
                            next = ids[i] instanceof ObjectId ? UIObjectsWriter.this.shortIdManager.getShortId((ObjectId)ids[i]) : (String)ids[i];
                            if (next == null || (index = sb.indexOf(next = next + ",")) == -1) continue;
                            sb.delete(index, index + next.length());
                        }
                        if (sb.length() == 0) {
                            file.delete();
                        } else {
                            writer = new FileWriter(file);
                            writer.write(sb.toString());
                        }
                    }
                    catch (IOException ioexc) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, ioexc);
                        throw ioexc;
                    }
                }
                Object var12_12 = null;
                {
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer == null) throw throwable;
                    writer.close();
                    throw throwable;
                }
                catch (IOException ioexc) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioexc) {}
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.removeFromGroupFile()");
        }

        private void addToFile(List shortIds, File file) throws IOException {
            this.addToFile(shortIds.toArray(new String[shortIds.size()]), file);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addToFile(String[] shortIds, File file) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.addToFile()");
            char[] buffer = null;
            StringBuffer newBuffer = new StringBuffer();
            InputStreamReader reader = null;
            OutputStreamWriter writer = null;
            try {
                try {
                    if (file.length() > 0L) {
                        buffer = new char[(int)file.length()];
                        reader = new FileReader(file);
                        reader.read(buffer);
                        reader.close();
                        reader = null;
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "    buffer.length is " + buffer.length);
                    }
                    if (buffer != null) {
                        newBuffer.append(buffer);
                    }
                    for (int i = 0; i < shortIds.length; ++i) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "    next is [" + shortIds[i] + "] newBuffer is [" + newBuffer + "]");
                        if (newBuffer.indexOf(shortIds[i]) != -1) continue;
                        newBuffer.append(shortIds[i]);
                        newBuffer.append(",");
                    }
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "    newBuffer.length() is " + newBuffer.length());
                    if (newBuffer.length() > 0 && (buffer == null || buffer.length != newBuffer.length())) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "    write file " + file.getName());
                        writer = new FileWriter(file);
                        writer.write(newBuffer.toString());
                    }
                }
                catch (IOException ioexc) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, ioexc);
                    throw ioexc;
                }
                Object var9_9 = null;
                {
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer == null) throw throwable;
                    writer.close();
                    throw throwable;
                }
                catch (IOException ioexc) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioexc) {}
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.addToFile()");
        }

        String[] getShortIds(ObjectId[] objectIds) {
            String[] result = null;
            if (objectIds != null) {
                result = new String[objectIds.length];
                for (int i = 0; i < objectIds.length; ++i) {
                    result[i] = UIObjectsWriter.this.shortIdManager.add(objectIds[i]);
                }
            }
            return result;
        }

        public void workCompleted(WorkEvent event) {
            Trace.trace(UIObjectsWriter.TRACE_MASKT, " <> UIObjectsWriter.Worker.workCompleted()");
            if (event.hasException()) {
                new FrameworkLog(UILog.logInfo, 1814, event.getException()).log();
            }
        }
    }
}

